Кэширование страниц
=================

Кэширование страниц — это кэширование всего содержимого страницы на стороне сервера. Позже, когда эта страница
будет снова запрошена, сервер вернет её из кэша вместо того чтобы генерировать её заново.

Кэширование страниц осуществляется при помощи [фильтра действия](structure-filters.md) [[yii\filters\PageCache]] и
может быть использовано в классе контроллера следующим образом:

```php
public function behaviors()
{
    return [
        [
            'class' => 'yii\filters\PageCache',
            'only' => ['index'],
            'duration' => 60,
            'variations' => [
                \Yii::$app->language,
            ],
            'dependency' => [
                'class' => 'yii\caching\DbDependency',
                'sql' => 'SELECT COUNT(*) FROM post',
            ],
        ],
    ];
}
```

Приведённый код задействует кэширование только для действия `index`. Содержимое страницы кэшируется максимум на 60 секунд
и варьируется в зависимости от текущего языка приложения. Кэшированная страница должна быть признана просроченной, если
общее количество постов изменилось.

Кэширование страниц очень похоже на [кэширования фрагментов](caching-fragment.md). В обоих случаях поддерживаются параметры
`duration` (продолжительность), `dependencies` (зависимости), `variations` (вариации), и `enabled` (включен). Главное
отличие заключается в том, что кэширование страницы реализовано в виде [фильтра действия](structure-filters.md),
а кэширование фрагмента в виде [виджета](structure-widgets.md).

Вы можете использовать вместе [кэширование фрагмента](caching-fragment.md),
[динамическое содержимое](caching-fragment.md#dynamic-content) и кэширование страницы.
