﻿Guía Definitiva de Yii 2.0
==========================

Este tutorial se publica con arreglo a los [Términos de Documentación Yii](http://www.yiiframework.com/doc/terms/).

Todos los derechos reservados.

2014 (c) Yii Software LLC.


Introducción
------------

* [Acerca de Yii](intro-yii.md)
* [Actualizar desde Yii 1.1](intro-upgrade-from-v1.md)


Primeros pasos
--------------

* [Instalar Yii](start-installation.md)
* [Funcionamiento de aplicaciones](start-workflow.md)
* [Hola a todos](start-hello.md)
* [Trabajar con formularios](start-forms.md)
* [Trabajar con bases de datos](start-databases.md)
* [Generar códigos con Gii](start-gii.md)
* [Adentrarse en Yii](start-looking-ahead.md)


Estructura de una aplicación
----------------------------

* [Información general](structure-overview.md)
* [Script de entrada](structure-entry-scripts.md)
* [Aplicaciones](structure-applications.md)
* [Componentes de una aplicación](structure-application-components.md)
* [Controladores](structure-controllers.md)
* [Modelos](structure-models.md)
* [Vistas](structure-views.md)
* [Filtros](structure-filters.md)
* [Widgets](structure-widgets.md)
* [Módulos](structure-modules.md)
* **TBD** [Recursos](structure-assets.md)
* **TBD** [Extensiones](structure-extensions.md)


Gestión de las peticiones
-------------------------

* [Información general](runtime-overview.md)
* [Bootstrapping](runtime-bootstrapping.md)
* [Routing](runtime-routing.md)
* **TBD** [Peticiones](runtime-requests.md)
* **TBD** [Respuestas](runtime-responses.md)
* **TBD** [Sesiones y Cookies](runtime-sessions-cookies.md)
* **TBD** [Procesamiento y generación de las URL](runtime-url-handling.md)
* **TBD** [Gestión de errores](runtime-handling-errors.md)
* **TBD** [Registro de anotaciones](runtime-logging.md)


Conceptos clave
---------------

* [Componentes](concept-components.md)
* **TBD** [Propiedades](concept-properties.md)
* **TBD** [Eventos](concept-events.md)
* [Comportamientos (Behaviors)](concept-behaviors.md)
* [Configuraciones](concept-configurations.md)
* [Alias](concept-aliases.md)
* [Autocarga de clases](concept-autoloading.md)
* **TBD** [Localizador de servicios (Service Locator)](concept-service-locator.md)
* **TBD** [Contenedor de inyección de dependencia](concept-di-container.md)


Trabajar con bases de datos
-----------------------------

* **TBD** [Objeto de acceso a datos](db-dao.md) - Conexión a una base de datos, consultas básicas, transacciones y manipulación de esquemas
* **TBD** [Constructor de consultas](db-query-builder.md) - Consulta de la base de datos utilizando una simple capa de abstracción
* **TBD** [Active Record](db-active-record.md) - ORM Active Record, recuperación y manipulación de registros y definición de relaciones
* **TBD** [Migraciones](db-migrations.md) - Control de versiones de bases de datos en el entorno de desarrollo en equipo
* **TBD** [Sphinx](db-sphinx.md)
* **TBD** [Redis](db-redis.md)
* **TBD** [MongoDB](db-mongodb.md)
* **TBD** [ElasticSearch](db-elastic-search.md)


Obtener datos de los usuarios
-----------------------------

* **TBD** [Crear formularios](input-forms.md)
* **TBD** [Validar datos](input-validation.md)
* **TBD** [Subir archivos](input-file-upload.md)
* **TBD** [Obtener datos para múltiples modelos](input-multiple-models.md)


Visualizar datos
----------------

* **TBD** [Formato de datos](output-formatting.md)
* **TBD** [Paginación](output-pagination.md)
* **TBD** [Ordenación](output-sorting.md)
* **TBD** [Proveedores de datos](output-data-providers.md)
* **TBD** [Widgets de datos](output-data-widgets.md)
* **TBD** [Trabajar con scripts de cliente](output-client-scripts.md)
* **TBD** [Utilización de temas](output-theming.md)


Seguridad
---------

* **TBD** [Autenticación](security-authentication.md)
* **TBD** [Autorización](security-authorization.md)
* **TBD** [Trabajar con contraseñas](security-passwords.md)
* **TBD** [Autenticar Clientes](security-auth-clients.md)
* **TBD** [Buenas prácticas](security-best-practices.md)


Caché
-----

* [Información general](caching-overview.md)
* [Caché de datos](caching-data.md)
* [Caché de fragmentos](caching-fragment.md)
* [Caché de páginas](caching-page.md)
* [Caché HTTP](caching-http.md)


Servicios Web RESTful 
---------------------

* **TBD** [Guía breve](rest-quick-start.md)
* **TBD** [Recursos (Resources)](rest-resources.md)
* **TBD** [Controladores](rest-controllers.md)
* **TBD** [Gestión de rutas](rest-routing.md)
* **TBD** [Formateo de respuestas](rest-response-formatting.md)
* **TBD** [Autenticación](rest-authentication.md)
* **TBD** [Límite de Rango](rest-rate-limiting.md)
* **TBD** [Gestión de versiones](rest-versioning.md)
* **TBD** [Gestión de errores](rest-error-handling.md)


Herramientas de Desarrollo
--------------------------

* **TBD** [Depurador y Barra de Herramientas de Depuración](tool-debugger.md)
* **TBD** [Generación de códigos con Gii](tool-gii.md)
* **TBD** [Generación de documentación de API](tool-api-doc.md)


Pruebas
------

* **TBD** [Información general](test-overview.md)
* **TBD** [Configuración del entorno de pruebas](test-environment-setup.md)
* **TBD** [Pruebas unitarias](test-unit.md)
* **TBD** [Pruebas funcionales](test-functional.md)
* **TBD** [Pruebas de aceptación](test-acceptance.md)
* **TBD** [Fixtures](test-fixtures.md)


Temas especiales
----------------

* **TBD** [Plantilla aplicación avanzada](tutorial-advanced-app.md)
* **TBD** [Creación de una aplicación desde cero](tutorial-start-from-scratch.md)
* **TBD** [Comandos de consola](tutorial-console.md)
* **TBD** [Validadores de base](tutorial-core-validators.md)
* **TBD** [Internacionalización](tutorial-i18n.md)
* **TBD** [Envío de correos electrónicos](tutorial-mailing.md)
* **TBD** [Mejora del rendimiento](tutorial-performance-tuning.md)
* **TBD** [Entorno de alojamiento compartido](tutorial-shared-hosting.md)
* **TBD** [Motores de plantillas](tutorial-template-engines.md)
* **TBD** [Trabajar con Código de Terceros](tutorial-yii-integration.md)


Widgets
-------

* GridView: link to demo page
* ListView: link to demo page
* DetailView: link to demo page
* ActiveForm: link to demo page
* Pjax: link to demo page
* Menu: link to demo page
* LinkPager: link to demo page
* LinkSorter: link to demo page
* **TBD** [Bootstrap Widgets](bootstrap-widgets.md)
* **TBD** [Jquery UI Widgets](jui-widgets.md)


Clases auxiliares
-----------------

* **TBD** [Información general](helper-overview.md)
* **TBD** [ArrayHelper](helper-array.md)
* **TBD** [Html](helper-html.md)
* **TBD** [Url](helper-url.md)
* **TBD** [Security](helper-security.md)

