@extends('layouts.layout')

@section('content')
<div class="col-md-12">
    <div class="card">
        <div class="header">
	        <h4 class="title">{{$title}}</h4>
	        <p class="category"></p>
	    </div>
	    <div class="content">
	    	<form action="{{route('receptionist.store')}}" method="POST">
	    	{{ csrf_field() }}
	    	<div class="row">
		    	<div class="col-md-5">
	                <div class="form-group @if($errors->has('nip')) has-error @endif"">
	                    <label>nip</label>
	                    <input type="text" class="form-control border-input" value="{{old('nip')}}" name="nip">
	                    <span id="helpBlock2" class="help-block">{{$errors->first('nip')}}</span>
	                </div>
	            </div>
		    	<div class="col-md-5">
	                <div class="form-group @if($errors->has('tahun_masuk')) has-error @endif"">
	                    <label>Tahun masuk</label>
	                    <input type="text" class="form-control border-input" value="{{old('tahun_masuk')}}" name="tahun_masuk">
	                    <span id="helpBlock2" class="help-block">{{$errors->first('tahun_masuk')}}</span>
	                </div>
	            </div>
            </div>
            <div class="row">
		    	<div class="col-md-10">
	                <div class="form-group @if($errors->has('nama_receptionist')) has-error @endif"">
	                    <label>Nama receptionist</label>
	                    <input type="text" class="form-control border-input" value="{{old('nama_receptionist')}}" name="nama_receptionist">
	                    <span id="helpBlock2" class="help-block">{{$errors->first('nama_receptionist')}}</span>
	                </div>
	            </div>
            </div>
            <div class="row">
		    	<div class="col-md-5">
	                <div class="form-group @if($errors->has('jabatan')) has-error @endif"">
	                    <label>jabatan</label>
	                    <select class="form-control border-input" name="jabatan">
	                    	@foreach($jabatan as $jur)
	                    	<option value="{{$jur}}" {{old('jabatan') == $jur ? 'selected' : ''}}>{{$jur}}</option>
	                    	@endforeach
	                    </select>
	                    <span id="helpBlock2" class="help-block">{{$errors->first('jabatan')}}</span>
	                </div>
	            </div>
	            
            </div>
            
            <div class="row">
            	<div class="col-md-12">
            		<a href="{{ route('receptionist.index') }}" class="btn btn-default">Cancel</a>
					<input type="submit" class="btn btn-default">
            	</div>
            </div>
	    	</form>
	    </div>
    </div>
</div>
@endsection