<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BeliLog extends Model
{
      protected $fillable =  ['menu_id','user_id','dibatalkan'];
      protected $casts = [
        'dibatalkan'  =>  'boolean'
      ];
      public function menu()
      {
        return $this->belongsTo('App\Menu');
      }//

      public function user()
      {
        return $this->belongsTo('App\User');
      }//

      public function scopedibatalkan($query)
      {
      return $query->where('dibatalkan', 1);
      }
      public function scopebeli($query)
      {
      return $query->where('dibatalkan', 0);
      }
}
