<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class reqRct extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {

        return [
            //
            'nip' => 'required|unique:tbl_receptionist,nip,'.$request->input('mhs_id'),
            'tahun_masuk' => 'required|date_format:"Y"',
            'nama_receptionist' => 'required'
        ];
    }

    public function messages(){
        return [
            'nip.required' => 'Nip harus diisi',
            'nip.unique' => 'Nip sudah terdaftar',
            'tahun_masuk.required' => 'Tahun masuk harus diisi',
            'tahun_masuk.date_format' => 'Format Tahun masuk harus berupa tahun',
            'nama_receptionist.required' => 'Nama receptionist harus diisi'

        ];
    }
}
